/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.util;

import java.util.NoSuchElementException;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class ModHelper {
    private static final String FABRIC_LOADER_ID = "fabricloader";
    private static final String QUILT_LOADER_ID = "quilt_loader";
    private static final String FORGE_LOADER_ID = "forge";

    public static ModMetadata getMeta(String modid) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(modid).orElseThrow(() -> new NoSuchElementException("Unable to find mod container for ID '%s'".formatted(modid)))).getMetadata();
    }

    public static ModMetadata getLoaderMeta() {
        if (ModHelper.isLoaded(FORGE_LOADER_ID)) {
            return ModHelper.getMeta(FORGE_LOADER_ID);
        }
        if (ModHelper.isLoaded(QUILT_LOADER_ID)) {
            return ModHelper.getMeta(QUILT_LOADER_ID);
        }
        return ModHelper.getMeta(FABRIC_LOADER_ID);
    }

    public static ModMetadata getGameMeta() {
        return ModHelper.getMeta("minecraft");
    }

    public static boolean isLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }
}

